/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.apiimpl.network.node.storage;

import com.raoulvdberge.refinedstorage.RS;
import com.raoulvdberge.refinedstorage.RSBlocks;
import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.storage.AccessType;
import com.raoulvdberge.refinedstorage.api.storage.IStorage;
import com.raoulvdberge.refinedstorage.api.storage.IStorageProvider;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDisk;
import com.raoulvdberge.refinedstorage.api.storage.disk.IStorageDiskContainerContext;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.IGuiStorage;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.NetworkNode;
import com.raoulvdberge.refinedstorage.apiimpl.network.node.storage.StorageDiskFluidStorageWrapper;
import com.raoulvdberge.refinedstorage.apiimpl.storage.cache.StorageCacheFluid;
import com.raoulvdberge.refinedstorage.block.BlockFluidStorage;
import com.raoulvdberge.refinedstorage.block.enums.FluidStorageType;
import com.raoulvdberge.refinedstorage.tile.TileFluidStorage;
import com.raoulvdberge.refinedstorage.tile.config.FilterConfig;
import com.raoulvdberge.refinedstorage.tile.config.IAccessType;
import com.raoulvdberge.refinedstorage.tile.config.IPrioritizable;
import com.raoulvdberge.refinedstorage.tile.config.IRSFilterConfigProvider;
import com.raoulvdberge.refinedstorage.tile.data.TileDataParameter;
import com.raoulvdberge.refinedstorage.util.AccessTypeUtils;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class NetworkNodeFluidStorage
extends NetworkNode
implements IGuiStorage,
IStorageProvider,
IRSFilterConfigProvider,
IPrioritizable,
IAccessType,
IStorageDiskContainerContext {
    public static final String ID = "fluid_storage";
    private static final String NBT_PRIORITY = "Priority";
    public static final String NBT_ID = "Id";
    private FluidStorageType type;
    private AccessType accessType = AccessType.INSERT_EXTRACT;
    private int priority = 0;
    private final FilterConfig config = new FilterConfig.Builder(this).allowedFilterTypeFluids().allowedFilterModeBlackAndWhitelist().filterModeBlacklist().filterSizeNine().setInitialCompare(2).build();
    private UUID storageId = UUID.randomUUID();
    private IStorageDisk<FluidStack> storage;

    public NetworkNodeFluidStorage(World world, BlockPos pos) {
        super(world, pos);
    }

    @Override
    public int getEnergyUsage() {
        return RS.INSTANCE.config.fluidStorageUsage;
    }

    @Override
    public void onConnectedStateChange(INetwork network, boolean state) {
        super.onConnectedStateChange(network, state);
        network.getNodeGraph().runActionWhenPossible(StorageCacheFluid.INVALIDATE);
    }

    @Override
    public void addItemStorages(List<IStorage<ItemStack>> storages) {
    }

    @Override
    public void addFluidStorages(List<IStorage<FluidStack>> storages) {
        if (this.storage == null) {
            this.loadStorage();
        }
        storages.add(this.storage);
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public NBTTagCompound write(NBTTagCompound tag) {
        super.write(tag);
        tag.func_186854_a(NBT_ID, this.storageId);
        return tag;
    }

    @Override
    public void read(NBTTagCompound tag) {
        super.read(tag);
        if (tag.func_186855_b(NBT_ID)) {
            this.storageId = tag.func_186857_a(NBT_ID);
            this.loadStorage();
        }
    }

    public void loadStorage() {
        IStorageDisk<FluidStack> disk = API.instance().getStorageDiskManager(this.world).get(this.storageId);
        if (disk == null) {
            disk = API.instance().createDefaultFluidDisk(this.world, this.getType().getCapacity());
            API.instance().getStorageDiskManager(this.world).set(this.storageId, disk);
            API.instance().getStorageDiskManager(this.world).markForSaving();
        }
        this.storage = new StorageDiskFluidStorageWrapper(this, disk);
    }

    public void setStorageId(UUID id) {
        this.storageId = id;
        this.markNetworkNodeDirty();
    }

    public UUID getStorageId() {
        return this.storageId;
    }

    public IStorageDisk<FluidStack> getStorage() {
        return this.storage;
    }

    @Override
    public NBTTagCompound writeConfiguration(NBTTagCompound tag) {
        super.writeConfiguration(tag);
        tag.func_74768_a(NBT_PRIORITY, this.priority);
        AccessTypeUtils.writeAccessType(tag, this.accessType);
        return tag;
    }

    @Override
    public void readConfiguration(NBTTagCompound tag) {
        super.readConfiguration(tag);
        if (tag.func_74764_b(NBT_PRIORITY)) {
            this.priority = tag.func_74762_e(NBT_PRIORITY);
        }
        this.accessType = AccessTypeUtils.readAccessType(tag);
    }

    public FluidStorageType getType() {
        IBlockState state;
        if (this.type == null && this.world != null && (state = this.world.func_180495_p(this.pos)).func_177230_c() == RSBlocks.FLUID_STORAGE) {
            this.type = (FluidStorageType)((Object)state.func_177229_b(BlockFluidStorage.TYPE));
        }
        return this.type == null ? FluidStorageType.TYPE_64K : this.type;
    }

    @Override
    public String getGuiTitle() {
        return "block.refinedstorage:fluid_storage." + this.getType().getId() + ".name";
    }

    @Override
    public TileDataParameter<Integer, ?> getTypeParameter() {
        return null;
    }

    @Override
    public TileDataParameter<Integer, ?> getRedstoneModeParameter() {
        return TileFluidStorage.REDSTONE_MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getCompareParameter() {
        return TileFluidStorage.COMPARE;
    }

    @Override
    public TileDataParameter<Integer, ?> getFilterParameter() {
        return TileFluidStorage.MODE;
    }

    @Override
    public TileDataParameter<Integer, ?> getPriorityParameter() {
        return TileFluidStorage.PRIORITY;
    }

    @Override
    public TileDataParameter<AccessType, ?> getAccessTypeParameter() {
        return TileFluidStorage.ACCESS_TYPE;
    }

    @Override
    public long getStored() {
        return TileFluidStorage.STORED.getValue();
    }

    @Override
    public long getCapacity() {
        return this.getType().getCapacity();
    }

    @Override
    public AccessType getAccessType() {
        return this.accessType;
    }

    @Override
    public void setAccessType(AccessType value) {
        this.accessType = value;
        if (this.network != null) {
            this.network.getFluidStorageCache().invalidate();
        }
        this.markNetworkNodeDirty();
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(int priority) {
        this.priority = priority;
        this.markNetworkNodeDirty();
        if (this.network != null) {
            this.network.getFluidStorageCache().sort();
        }
    }

    @Override
    @Nonnull
    public FilterConfig getConfig() {
        return this.config;
    }
}

